import React, {useEffect, useState} from 'react';
import logo from './logo.svg';

import './styles/normalize.css';
import './styles/variables.css';
import './App.scss';
import {
  Routes,
  Route,
  useParams,
  Navigate,
  redirectDocument,
  redirect,
  useNavigate,
} from 'react-router-dom';
import MainPage from './pages/MainPage/MainPage';
import AboutPage from './pages/AboutPage/AboutPage';
import Footer from './components/Footer/Footer';
import BlogPage from './pages/BlogPage/BlogPage';
import BlogArticle from './pages/BlogArticle/BlogArticle';
import ProductDescriptionPage from './pages/ProductDescriptionPage/ProductDescriptionPage';
import ProductsPage from './pages/ProductsPage/ProductsPage';
import NewCases from './pages/new-case/NewCases';
import Solutions from './pages/Solutions/Solutions';
import ChatBot from './pages/chatbot/page';
import Contacts from './pages/ContactsPage/ContactsPage';
import {useDispatch, useSelector} from 'react-redux';
import {AppDispatch, RootState} from './store/store';
import {setLanguages} from './store/languages/actions';
import ParamParser from './helper/ParamParser';
import CarManagementSystem from './pages/ProductsDescriptionDefault/CarManagmentSystem';
import Counting from './pages/ProductsDescriptionDefault/Counting';
import Industrious from './pages/ProductsDescriptionDefault/Industrious';
import ObjectDetection from './pages/ProductsDescriptionDefault/ObjectDetection';
import Safety from './pages/ProductsDescriptionDefault/Safety';
import Logistics from './pages/Solutions/Cities';
import Cities from './pages/Solutions/Cities';
import Security from './pages/Solutions/Security';

function App() {
  const lang = useSelector((state: RootState) => state.language);
  const navigate = useNavigate();
  const dispatch: AppDispatch = useDispatch();
  // useEffect(() => {
  //   document.body.setAttribute(
  //     'data-lang',
  //     lang.selectedLanguage === 'en' ? 'en' : 'עב',
  //   );
  // }, [lang]);
  useEffect(() => {
    const currentUrl = window.location.pathname;
    let currentLang = localStorage.getItem('language');
    let langParse = JSON.parse(currentLang as string);
    if (currentUrl.length <= 3) {
      if (!langParse) {
        navigate(`/en`);
      } else {
        navigate(
          `/${langParse.current.toLocaleLowerCase() === 'en' ? 'en' : 'he'}`,
        );
      }
    }
  }, []);

  return (
    <div className='App'>
      <Routes>
        <Route path='/:lang' element={<MainPage />} />
        <Route path='/:lang' element={<MainPage />} />

        <Route path='/:lang/about' element={<AboutPage />} />
        <Route path='/:lang/products' element={<ProductsPage />} />
        {/*  //! main page  */}
        {/* <Route
          path='/:lang/products/:name'
          element={<ProductDescriptionPage />}
        /> */}
        {/*  //! main page  */}

        {/* //? test pages */}
        <Route
          path='/:lang/products/car-management-system'
          element={<CarManagementSystem />}
        />
        <Route path='/:lang/products/counting' element={<Counting />} />
        <Route path='/:lang/products/industrion' element={<Industrious />} />
        <Route
          path='/:lang/products/object-detection'
          element={<ObjectDetection />}
        />
        <Route path='/:lang/products/safety' element={<Safety />} />
        {/* //? test pages */}

        <Route path='/:lang/contacts' element={<Contacts />} />
        {/* <Route path="/blog" element={<BlogPage />} /> */}
        {/* <Route path="/blog/:name" element={<BlogArticle />} /> */}
        <Route path='/:lang/chatbot' element={<ChatBot />} />
        <Route path='/:lang/new-case' element={<NewCases />} />
        {/* <Route path='/:lang/solutions/:name' element={<Solutions />} /> */}
        <Route path='/:lang/solutions/logistics' element={<Solutions />} />
        <Route path='/:lang/solutions/cities' element={<Cities />} />
        <Route path='/:lang/solutions/security' element={<Security />} />
      </Routes>
      <div className='padding-space-footer bg-dark'>
        <Footer />
      </div>
    </div>
  );
}

export default App;
