import React, {FC} from 'react';

import AboutUsLinks from './AboutUsLinks';
import './AboutUs.scss';
import {Link, useParams} from 'react-router-dom';
import {useSelector} from 'react-redux';
import {RootState} from '../../store/store';

const AboutUs: FC = () => {
  const about = useSelector(
    (state: RootState) => state.language.currentLanguage.aboutUs,
  );
  const lang = useSelector(
    (state: RootState) => state.language.selectedLanguage,
  );
  return (
    <div className='about-us'>
      <div className='about-us__wrap wrap'>
        <div className='about-us__row'>
          <div className='about-us__info'>
            <h2 className=' h2 about-us__title '>{about.title}</h2>
            <p className='about-us__desc medium-font  '>
              {about.desc.map((item: string, i: any) => (
                <span key={i}>{item}</span>
              ))}
            </p>
            <Link
              to={`/${lang}/products`}
              className='about-us__button button-orange '
            >
              {about.button}
            </Link>
          </div>
          <div className='about-us__additional'>
            <span className='about-us__line'></span>
            <AboutUsLinks items={about.ABOUT_US_ITEMS} />
          </div>
        </div>
      </div>
    </div>
  );
};

export default AboutUs;
