import React, {FC} from 'react';
import Card from './Card/Card';

import './Benefits.scss';
import {useSelector} from 'react-redux';
import {RootState} from '../../store/store';
import {BenefitsCardType, CardType} from '../../constants/type';
import ClientCard from '../ClientCard/ClientCard';

const Benefits: FC = () => {
  const benefits = useSelector(
    (state: RootState) => state.language.currentLanguage.benefits,
  );
  return (
    <div className='benefits'>
      <div className='benefits__wrap wrap'>
        <h2 className='h2 benefits__title'>{benefits.title}</h2>
        <p className='benefits__desc'>{benefits.desc}</p>
        <div className='benefits__flex'>
          <div className='benefits__img'></div>
          <div className='benefits__row'>
            {benefits.BENEFITS_CARDS.map(
              (item: BenefitsCardType, index: any) => {
                return (
                  <div key={index} className='benefits__card'>
                    <Card item={item} />
                  </div>
                );
              },
            )}
          </div>
        </div>
        <div className='benefits__clients'>
          <h2 className='h2 benefits__title'>{benefits.subTitle}</h2>
          <p className='benefits__desc'>{benefits.subDesc}</p>
          <div className='benefits__client_row'>
            {benefits.clientCards.map((card: CardType, i: any) => (
              <div className='benefits__client_card' key={i}>
                <ClientCard card={card} />
              </div>
            ))}
          </div>
        </div>
      </div>
    </div>
  );
};

export default Benefits;
