import React, {FC} from 'react';
import './Card.scss';

interface CardI {
  item: {
    src: string;
    title: string;
    desc: string;
  };
}
const Card: FC<CardI> = ({item}) => {
  return (
    <div className='card-benefits'>
      <div className='card-benefits__box'>
        <div
          className='card-benefits__icon'
          style={{background: `center/cover no-repeat url(${item.src})`}}
        ></div>
        <h4 className='h4 card-benefits__title'>{item.title}</h4>
      </div>
      <p className='card-benefits__desc small-font '>{item.desc}</p>
    </div>
  );
};

export default Card;
