import React, {FC} from 'react';

import './CardAbout.scss';
import {CardAboutT} from '../../types/types';
import {Link} from 'react-router-dom';
import {useSelector} from 'react-redux';
import {RootState} from '../../store/store';

const CardAbout: FC<CardAboutT> = ({odd, src, title, desc, withButton}) => {
  const lang = useSelector(
    (state: RootState) => state.language.selectedLanguage,
  );
  const state = useSelector(
    (state: RootState) => state.language.currentLanguage,
  );
  return (
    <div className={`about-card ${odd ? 'active' : 'none'}`}>
      <div className='about-card__wrap wrap'>
        <div className='about-card__row'>
          <div
            className='about-card__img'
            style={{background: `center/cover no-repeat url(${src})`}}
          ></div>
          <div className='about-card__info '>
            <h2 className='h2 about-card__title'>{title} </h2>
            <p className='about-card__desc'>
              {desc.map((text, index) => {
                return <span key={index}>{text}</span>;
              })}
            </p>
            {withButton && (
              <Link
                to={`/${lang}/products`}
                className='about-card__button button-orange'
              >
                {state.button_title}
              </Link>
            )}
          </div>
        </div>
      </div>
    </div>
  );
};

export default CardAbout;
