import React, {FC, ReactNode} from 'react';
import './ContactCard.scss';
import {CardContactType} from '../../types/types';
import {useSelector} from 'react-redux';
import {RootState} from '../../store/store';

type ContactCardT = {
  card: CardContactType;
};
const ContactCard: FC<ContactCardT> = ({card}) => {
  const state = useSelector(
    (state: RootState) => state.language.selectedLanguage,
  );
  return (
    <div className='contact-card'>
      <div className='contact-card__wrap'>
        <div
          className='contact-card__img'
          style={{background: `center/contain no-repeat url(${card.src})`}}
        ></div>
        <div className='contact-card__box'>
          <p className='contact-card__title large-font'>{card.title}</p>
          <p className={`contact-card__desc`}>{card.desc}</p>
          <a
            href={card.phone ? `tel:${card.url}` : `/${state}/${card.url}`}
            className='button-orange contact-card__button'
            target='_blank'
          >
            {card.labelUrl}
          </a>
        </div>
      </div>
    </div>
  );
};

export default ContactCard;
