import React, {FC, ReactNode} from 'react';

import {CardContactType} from '../../types/types';
import './ContactInfo.scss';
import {Link} from 'react-router-dom';
import {useSelector} from 'react-redux';
import {RootState} from '../../store/store';

type ContactCardT = {
  card: CardContactType;
};
const ContactInfo: FC<ContactCardT> = ({card}) => {
  const state = useSelector(
    (state: RootState) => state.language.selectedLanguage,
  );
  return (
    <div className='contact-info'>
      <h2 className='contact-info__title h2'>{card.title}</h2>
      <p className='contact-info__desc '>{card.desc}</p>
      <Link to={`/${state}/contacts`} className='button-orange'>
        Contact us now
      </Link>
    </div>
  );
};

export default ContactInfo;
