import React, {FC} from 'react';
import './Contacts.scss';
import {Link} from 'react-router-dom';
import {useSelector} from 'react-redux';
import {RootState} from '../../store/store';

const Contacts: FC = () => {
  const contacts = useSelector(
    (state: RootState) => state.language.currentLanguage.contacts,
  );
  const lang = useSelector(
    (state: RootState) => state.language.selectedLanguage,
  );
  return (
    <div className='contacts'>
      <div className='contacts__wrap wrap'>
        <h2 className='h2 contacts__title'>{contacts.title}</h2>
        <p className='contacts__desc'>{contacts.desc}</p>
        <Link
          to={`/${lang}/contacts`}
          className='contacts__button button-orange'
        >
          {contacts.button}
        </Link>
      </div>
    </div>
  );
};

export default Contacts;
