import React, {FC} from 'react';
import './Footer.scss';
import {Link} from 'react-router-dom';
// import {FOOTER_PRODUCTS, MENU_ITEMS} from '../../constants/constants_en';
import {useSelector} from 'react-redux';
import {RootState} from '../../store/store';
import {NavLinkProps} from '../Header/Navigation';

const Footer: FC = () => {
  // lang.selectedLanguage)
  const state = useSelector(
    (state: RootState) => state.language.selectedLanguage,
  );
  const header = useSelector(
    (state: RootState) => state.language.currentLanguage,
  );
  const footer = useSelector(
    (state: RootState) => state.language.currentLanguage.footer,
  );
  return (
    <div className='footer'>
      <div className='footer__wrap wrap'>
        <Link to={`/${state}`} className='footer__logo logo'></Link>
        <div className='footer__row'>
          <div className='footer__navigate'>
            <nav className='footer__nav'>
              <div>
                <p className='footer__label large-font'>{footer.titleA}</p>
                <ul className='footer__list'>
                  {header.MENU_ITEMS.map((item: NavLinkProps, index: any) => {
                    return (
                      <li key={index}>
                        <Link
                          to={`/${state}${item.link}`}
                          className='footer__link'
                        >
                          {item.label}
                        </Link>
                      </li>
                    );
                  })}
                </ul>
              </div>
            </nav>
            <div className='footer__nav'>
              <div>
                <p className='footer__label large-font'>{footer.titleB}</p>
                <ul className='footer__list'>
                  {footer.FOOTER_PRODUCTS.map((item: any, index: any) => {
                    return (
                      <li key={index}>
                        <Link
                          to={`${state}/products${item.link}`}
                          className='footer__link'
                        >
                          {item.label}
                        </Link>
                      </li>
                    );
                  })}
                </ul>
              </div>
            </div>
          </div>
          <div className='footer__info'>
            <div className='footer__box'>
              <p className='footer__label large-font _contacts'>
                {footer.titleC}
              </p>
              <p className='footer__desc small-font'>
                <span>
                  {footer.phone}
                  <br />
                  <a href='tel:972505025094' dir='ltr'>
                    +972 505025094
                  </a>
                  <br />
                  <br />
                  www.wesmart.co.il <br />
                  <br />
                  <a href='mailto:info@wesmart.org.il' dir='ltr'>
                    info@wesmart.org.il
                  </a>
                </span>
              </p>
            </div>
            <div className='footer__box'>
              <p className='footer__label large-font _address'>
                {footer.titleD}
              </p>
              <p className='footer__desc small-font'>
                <span>
                  {footer.address}
                  <br />
                  2165379
                </span>
              </p>
            </div>
          </div>
        </div>
        <div className='footer__additional-info'>
          <p className='footer__copy'>{footer.copy}</p>
          <ul className='footer__additional-link'>
            <li>
              <Link to={`/`} className='footer__link'>
                {footer.cookie}
              </Link>
            </li>
            <li>
              <Link to={`/`} className='footer__link'>
                {footer.legal}
              </Link>
            </li>
            <li>
              <Link to={`/`} className='footer__link'>
                {footer.policy}
              </Link>
            </li>
          </ul>
        </div>
      </div>
    </div>
  );
};

export default Footer;
