'use client';
import React, {FC, useState} from 'react';
import './Form.scss';
import {useSelector} from 'react-redux';
import {RootState} from '../../store/store';

const Form: FC = () => {
  const [isFocus, setIsFocus] = useState(false);

  const state = useSelector(
    (state: RootState) => state.language.currentLanguage.form,
  );

  const handelFocus = (e: React.FocusEvent<HTMLInputElement>) => {
    const {target} = e;
    let line = target.closest('.form__box')?.querySelector('.form__line ');
    line?.classList.add('active');
  };
  const handleBlur = (e: React.FocusEvent<HTMLInputElement>) => {
    const {target} = e;
    let line = target.closest('.form__box')?.querySelector('.form__line ');
    line?.classList.remove('active');
  };

  const handelChange = (e: React.FormEvent<HTMLInputElement>) => {
    const {currentTarget} = e;
    if (currentTarget?.value.length >= 1) {
      currentTarget.nextElementSibling?.classList.add('active');
      return;
    } else {
      currentTarget.nextElementSibling?.classList.remove('active');
    }
  };
  const buttonCloseClick = (e: React.MouseEvent<HTMLButtonElement>) => {
    const currentButton = e.currentTarget; // получаем текущую кнопку
    const previousElement =
      currentButton.previousElementSibling as HTMLInputElement;
    previousElement.value = '';
    e.currentTarget.classList.remove('active');
  };
  return (
    <form action='' name='form-submit' className='form'>
      <div className='form__box'>
        <label htmlFor='name'>{state.name} *</label>
        <div className='form__inner'>
          <input
            onFocus={handelFocus}
            onBlur={handleBlur}
            onChange={handelChange}
            type='text'
            id='name'
            name='nameInput'
            className='form__input'
            placeholder={state.labelA}
            required
          />
          <button
            className='form__button_close'
            onClick={buttonCloseClick}
          ></button>
        </div>
        <span className={`form__line `}></span>
      </div>
      <div className='form__box'>
        <label htmlFor='email'>{state.email} *</label>
        <div className='form__inner'>
          <input
            onFocus={handelFocus}
            onChange={handelChange}
            onBlur={handleBlur}
            id='email'
            type='email'
            name='emailInput'
            className='form__input'
            placeholder={state.labelB}
            required
          />
          <button
            className='form__button_close'
            onClick={buttonCloseClick}
          ></button>
        </div>
        <span className='form__line'></span>
      </div>
      <div className='form__box _phone'>
        <label htmlFor='phone'>{state.phone}</label>
        <div className='form__inner'>
          <ul className='form__list'>
            <li className='form__item'>{state.labelC}</li>
          </ul>
          <div className='form__flex'>
            <input
              id='phone'
              type='text'
              onChange={handelChange}
              onFocus={handelFocus}
              onBlur={handleBlur}
              name='phoneInput'
              className='form__input'
              placeholder={state.phonePlacholder}
              required
            />
            <span className='form__line'></span>
          </div>
        </div>
      </div>
      <div className='form__box'>
        <label htmlFor='company'>{state.company} *</label>
        <div className='form__inner'>
          <input
            id='company'
            type='text'
            name='emailInput'
            onChange={handelChange}
            onFocus={handelFocus}
            onBlur={handleBlur}
            className='form__input'
            placeholder={state.labelB}
            required
          />
          <button
            className='form__button_close'
            onClick={buttonCloseClick}
          ></button>
        </div>
        <span className='form__line'></span>
      </div>
      <div className='form__box'>
        <label htmlFor='company'>{state.company} * </label>
        <textarea
          placeholder={state.textArea}
          className='form__textarea'
        ></textarea>
      </div>
      <button type='submit' className='button-orange'>
        {state.button}
      </button>
    </form>
  );
};
export default Form;
