import React, {FC, useState} from 'react';
import './Header.scss';
import Navigation from './Navigation';
import {Link} from 'react-router-dom';
import {MENU_ITEMS} from '../../constants/constants_en';
import SelectLanguage from '../SelectLanguage/SelectLanguage';
import {RootState} from '../../store/store';
import {useSelector} from 'react-redux';

const Header: FC = () => {
  const header = useSelector(
    (state: RootState) => state.language.currentLanguage,
  );
  const state = useSelector(
    (state: RootState) => state.language.selectedLanguage,
  );
  return (
    <header className='header'>
      <div className='header__wrap wrap'>
        <Link to={`/${state}`} className='header__logo logo'></Link>
        <nav className='header__nav'>
          <ul className='header__list'>
            <Navigation navLink={header.MENU_ITEMS} />
          </ul>
        </nav>
        <SelectLanguage />
        <Link
          to={`/${state}/products`}
          className='header__button button-orange'
        >
          {header.button_title}
        </Link>
      </div>
    </header>
  );
};

export default Header;
