'use client';

import {useSelector} from 'react-redux';
import {Link, NavLink, useLocation} from 'react-router-dom';
import {RootState} from '../../store/store';
import {useState} from 'react';

export type NavLinkProps = {
  label: string;
  link: string;
};
type Props = {
  navLink: Array<NavLinkProps>;
};

export default function Navigation({navLink}: Props) {
  const state = useSelector(
    (state: RootState) => state.language.selectedLanguage,
  );
  const location = useLocation();
  const [activeIndex, setActiveIndex] = useState(-1);

  const handleLinkClick = (index: any) => {
    setActiveIndex(index);
  };

  return (
    <>
      {navLink.map((item, index) => (
        <li key={index}>
          <NavLink
            to={`/${state}${item.link}`}
            className={`header__link ${
              location.pathname.endsWith(item.link) ? '' : 'none  '
            }`}
            onClick={() => handleLinkClick(index)}
          >
            {item.label}
          </NavLink>
        </li>
      ))}
    </>
  );
}
