import React, {FC} from 'react';
import './Preview.scss';
import {Link} from 'react-router-dom';
import {useSelector} from 'react-redux';
import {RootState} from '../../store/store';

const Preview: FC = () => {
  const preview = useSelector(
    (state: RootState) => state.language.currentLanguage.preview,
  );
  const lang = useSelector(
    (state: RootState) => state.language.selectedLanguage,
  );
  return (
    <div className='preview'>
      <div className='wrap'>
        <div className='preview__wrap '>
          <h1 className='h1 preview__title'>{preview.title}</h1>
          <p className='preview__desc'>{preview.desc}</p>
          <Link
            to={`/${lang}/products`}
            className='preview__button button-orange'
          >
            {preview.button}
          </Link>
        </div>
      </div>
    </div>
  );
};

export default Preview;
