import React, {FC} from 'react';
import './ProductCard.scss';
import {ProductCardT} from '../../types/types';
import {Link} from 'react-router-dom';
import {replaceText} from '../../helper/funcs';
import {useSelector} from 'react-redux';
import {Root} from 'react-dom/client';
import {RootState} from '../../store/store';

const ProductCard: FC<ProductCardT> = ({card, odd}) => {
  const state = useSelector((state: RootState) => state.language);
  return (
    <div className={`product-card ${odd ? 'active' : 'none'}`}>
      <div className='product-card__wrap'>
        <div className='product-card__row'>
          <div
            className='product-card__img'
            style={{background: `right/cover no-repeat url(${card.img})`}}
          ></div>
          <div className='product-card__info'>
            <div className='product-card__box'>
              <span className='product-card__date'>{card.date}</span>
              <h2 className='h2 product-card__name'>{card.name}</h2>
              <div
                className='product-card__img'
                style={{background: `right/cover no-repeat url(${card.img})`}}
              ></div>
            </div>
            <div className='product-card__container'>
              <h4 className='h4 product-card__title'>{card.title}</h4>
              <p className='product-card__desc'>{card.desc}</p>
              {card.isGeneralPage ? (
                <Link
                  to={`/${state.selectedLanguage}/products${card?.url}`}
                  className='product-card__link'
                >
                  {state.currentLanguage.button_more}
                </Link>
              ) : (
                <button className='product-card__button button-orange'>
                  {state.currentLanguage.button_title}
                </button>
              )}
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default ProductCard;
