import React, {FC} from 'react';
import './Card.scss';
import {Link} from 'react-router-dom';
import {useSelector} from 'react-redux';
import {RootState} from '../../../store/store';

export type CardItemType = {
  link: string;
  src: string;
  label: string;
  title: string;
  desc: string;
  titleOfLink: string;
};
interface CardI {
  item: CardItemType;
}

const Card: FC<CardI> = ({item}) => {
  const state = useSelector(
    (state: RootState) => state.language.selectedLanguage,
  );
  return (
    <Link to={`/${state}/solutions${item.link}`} className='card'>
      <div
        className='card__img'
        style={{background: `center/cover no-repeat url(${item.src})`}}
      ></div>
      <div className='card__info'>
        <p className='card__label'>{item.label}</p>
        <h2 className='h2 card__title'>{item.title}</h2>
        <p className='card__desc'>{item.desc}</p>
        <p className='card__link '>{item.titleOfLink}</p>
      </div>
    </Link>
  );
};
export default Card;
