import React, {FC, useState} from 'react';
import Card, {CardItemType} from './Card/Card';
import './Suggestion.scss';
import {RootState} from '../../store/store';
import {useSelector} from 'react-redux';

const Suggestions: FC = () => {
  const suggestions = useSelector(
    (state: RootState) => state.language.currentLanguage.suggestions,
  );
  return (
    <div className='suggestion'>
      <div className='suggestion__wrap wrap'>
        <h2 className='h2 suggestion__title'>{suggestions.title}</h2>
        <p className='suggestion__desc small-font '>{suggestions.desc}</p>
        <div className='suggestion__row'>
          {suggestions.PRODUCT_CARDS.map((item: CardItemType, index: any) => {
            return (
              <div className='suggestion__card' key={index}>
                <Card item={item} />
              </div>
            );
          })}
        </div>
      </div>
    </div>
  );
};

export default Suggestions;
