interface MenuItem {
  label: string;
  link: string;
}
type Text = string;
type MenuItemsTypes = {
  label: string;
  link: string;
  url?: string;
};
export type AboutUsType = {
  label: string;
  url: string;
  title: string;
  titleOfLink: string;
};

type ProductCardType = {
  link: string;
  src: string;
  label: string;
  title: string;
  desc: string;
  titleOfLink: string;
};
export type CategoryT = {
  label: string;
  title: string;
  url?: string;
};
export type CardT = {
  url?: string;
  img: string;
  odd: boolean;
  date: string;
  name: string;
  title: string;
  desc: string;
  isGeneralPage: boolean;
};
export type BenefitsCardType = {
  src: string;
  title: string;
  desc: string;
};
export type CardType = {
  desc: string;
  name: string;
  position: string;
  src: string;
};
export type CardContactType = {
  url?: string;
  src?: string;
  labelUrl?: string;
  title: string;
  desc: string;
  phone?: boolean;
};
export type ClientCardType = {
  card: CardType;
};
type desc = {
  title: string;
  desc: Array<string>;
};

export interface InfoT {
  MENU_ITEMS: MenuItem[];
  button_title: string;
  button_more: string;
  preview: {
    title: string;
    desc: string;
    button: string;
  };
  aboutUs: {
    title: string;
    desc: Array<Text>;
    button: string;
    ABOUT_US_ITEMS: Array<AboutUsType>;
  };
  suggestions: {
    title: Text;
    desc: Text;
    PRODUCT_CARDS: Array<ProductCardType>;
  };
  benefits: {
    subTitle: Text;
    subDesc: Text;
    title: Text;
    desc: Text;
    BENEFITS_CARDS: Array<BenefitsCardType>;
    clientCards: Array<CardType>;
  };
  contacts: {
    title: string;
    desc: string;
    button: string;
  };
  footer: {
    copy: string;
    cookie: string;
    legal: string;
    policy: string;
    address: string;
    phone: string;
    titleA: string;
    titleB: string;
    titleC: string;
    titleD: string;
    FOOTER_PRODUCTS: Array<MenuItemsTypes>;
  };
  aboutPage: {
    title: Text;
    desc: Text;
    button: Text;
    text: Text;
    textBox: Array<Text>;
    bannerTitle: Text;
    bannerDesc: Text;
    boxTitle: Text;
    boxDesc: Text;
    cardTitle: Text;
    cardTitleD: Text;
    cardDescD: Array<Text>;
    cardDescB: Array<Text>;
    cardDescC: Array<Text>;
    cardDesc: Array<Text>;
    cardTitleB: Text;
    cardTitleC: Text;
  };
  contactPage: {
    title: Text;
    desc: Text;
    CONTACT_CARDS: Array<CardContactType>;
  };
  product: {
    title: Text;
    desc: Array<Text>;
    text: Text;
    PRODUCT_CARD: Array<CardT>;
  };
  safety: {
    title: Text;
    desc: Array<Text>;
    cardAboutA: desc;
    cardAboutC: desc;
    DEFAULT_PRODUCT_LINK: Array<CategoryT>;
    DEFAULT_CARD: CardT;
  };
  objectDetection: {
    title: Text;
    desc: Array<Text>;
    cardAboutA: desc;
    cardAboutC: desc;
    DEFAULT_PRODUCT_LINK: Array<CategoryT>;
    DEFAULT_CARD: CardT;
  };
  carSystem: {
    title: Text;
    desc: Array<Text>;

    cardAboutA: desc;
    cardAboutB: desc;
    cardAboutC: desc;
    DEFAULT_PRODUCT_LINK: Array<CategoryT>;
    DEFAULT_CARD: CardT;
  };
  industrion: {
    title: Text;
    desc: Array<Text>;

    cardAboutA: desc;
    cardAboutB?: desc;
    cardAboutC: desc;
    DEFAULT_PRODUCT_LINK: Array<CategoryT>;
    DEFAULT_CARD: CardT;
  };
  counting: {
    title: Text;
    desc: Array<Text>;

    cardAboutA: desc;
    cardAboutB?: desc;
    cardAboutC: desc;
    DEFAULT_PRODUCT_LINK: Array<CategoryT>;
    DEFAULT_CARD: CardT;
  };
  description: {
    title: Text;
    desc: Array<Text>;

    cardAboutA: desc;
    cardAboutB: desc;
    cardAboutC: desc;
    DEFAULT_PRODUCT_LINK: Array<CategoryT>;
    DEFAULT_CARD: CardT;
  };
  security: {
    bg?: string;
    card: {
      title: string;
      desc: string;
    };
    appTitle: Text;
    title: string;
    CardAboutB: desc;
    BENEFITS_CARDS_LOGISTICS: Array<BenefitsCardType>;
    CardAboutA: desc;
    desc: Array<Text>;
    appDesc: Array<Text>;
  };
  citiesPage: {
    bg?: string;
    card: {
      title: string;
      desc: string;
    };
    appTitle: Text;
    title: string;
    CardAboutB: desc;
    BENEFITS_CARDS_LOGISTICS: Array<BenefitsCardType>;
    CardAboutA: desc;
    desc: Array<Text>;
    appDesc: Array<Text>;
  };
  solutionPage: {
    card: {
      title: string;
      desc: string;
    };
    appTitle: Text;
    title: string;
    CardAboutB: desc;
    BENEFITS_CARDS_LOGISTICS: Array<BenefitsCardType>;
    CardAboutA: desc;
    desc: Array<Text>;
    appDesc: Array<Text>;
  };
  chatBot: {
    title: Text;
    desc: Array<Text>;
    CHATBOT_CARDS_DF: Array<{title: string; desc: string}>;
    chatMessage: Text;
    placeholder: Text;
  };
  newCase: {
    title: Text;
    desc: Text;
    subTitle: Text;
    phoneLabel: Text;
    emailLabel: Text;
  };
  form: {
    name: Text;
    labelA: Text;
    email: Text;
    labelB: Text;
    phone: Text;
    labelC: Text;
    phonePlacholder: Text;
    company: Text;
    textArea: Text;
    button: Text;
  };
}
