'use client';
import React, {FC, useEffect} from 'react';
import {BASIC_TEXT} from '../../constants/constants_en';
import CardAbout from '../../components/CardAbout/CardAbout';
import Header from '../../components/Header/Header';
import './AboutPage.scss';
import MobileHeader from '../../components/MobileHeader/MobileHeader';
import useResponsiveHeader from '../../components/useResponsiveHeader/useResponsiveHeader';
import Contacts from '../../components/Contacts/Contacts';
import {Link, useLocation, useParams} from 'react-router-dom';
import img1 from '../../asserts/about-img_1.png';
import img2 from '../../asserts/Logistics.png';
import {useSelector} from 'react-redux';
import {RootState} from '../../store/store';
import ParamParser from '../../helper/ParamParser';

const About: FC = () => {
  const parserParam = ParamParser();
  const {isMobileHeader, isSmallScreen, showHeader, handleClick} =
    useResponsiveHeader();
  const {pathname} = useLocation();
  const aboutPage = useSelector(
    (state: RootState) => state.language.currentLanguage.aboutPage,
  );
  const lang = useSelector(
    (state: RootState) => state.language.selectedLanguage,
  );
  useEffect(() => {
    document?.querySelector('body')?.scrollTo(0, 0);
  }, [pathname]);
  return (
    <div className='about-page'>
      {isSmallScreen && (
        <MobileHeader isActive={isMobileHeader} handelClick={handleClick} />
      )}
      <div className={`about-page__header blackout`}>
        {showHeader && <Header />}
        <div className={`about-page__info wrap`}>
          <h1 className={`about-page__title h1`}>{aboutPage.title}</h1>
          <p className='about-page__desc'>{aboutPage.desc}</p>
          <Link
            to={`/${lang}/products`}
            className={`about-page__button  button-orange`}
          >
            {aboutPage.button}
          </Link>
        </div>
      </div>
      <div className='padding-space bg-light '>
        <div className={`about-page__paragraphs  wrap`}>
          <div className='about-page__row'>
            <div className='about-page__box'>
              <h2 className={`h2 about-page__text`}>{aboutPage.text}</h2>
              <p className='about-page__text_info'>
                {aboutPage.textBox.map((text: any, i: any) => (
                  <span key={i}>{text}</span>
                ))}
              </p>
              <Link
                to={`/${lang}/products`}
                className={`about-page__button button-orange`}
              >
                {aboutPage.button}
              </Link>
            </div>
            <div className='about-page__image'></div>
          </div>
        </div>
      </div>
      <CardAbout
        odd={true}
        src={img1}
        title={aboutPage.cardTitle}
        desc={aboutPage.cardDesc}
      />
      <div className='padding-space-top _banner'>
        <div className={`about-page__banner blackout`}>
          <div className='wrap'>
            <p>{aboutPage.bannerTitle}</p>
            <span>{aboutPage.bannerDesc}</span>
          </div>
        </div>
      </div>
      <div className={`padding-space about-page__products`}>
        <CardAbout
          odd={true}
          src={img2}
          title={aboutPage.cardTitleB}
          desc={aboutPage.cardDescB}
        />
      </div>

      <div className={`padding-space-top bg-dark`}>
        <div className='about-page__box_desc'>
          <div className='wrap'>
            <h2 className='h2'> {aboutPage.boxTitle}</h2>
            <span>{aboutPage.boxDesc}</span>
            <Link to={`/${lang}/products`} className='button-orange'>
              {aboutPage.button}
            </Link>
          </div>
          <div className='about-page__bg'></div>
        </div>
      </div>
      <div className={`padding-space about-page__products`}>
        <CardAbout
          odd={false}
          src={img1}
          title={aboutPage.cardTitleC}
          desc={aboutPage.cardDescC}
        />
      </div>
      <div className={`about-page__products`}>
        <CardAbout
          odd={true}
          src={img2}
          title={aboutPage.cardTitleD}
          desc={aboutPage.cardDescD}
        />
      </div>
      <div className='padding-space bg-light'>
        <div className='wrap'>
          <Contacts />
        </div>
      </div>
    </div>
  );
};

export default About;
