import React, {FC, useEffect} from 'react';
import './BlogPage.scss';
import Header from '../../components/Header/Header';
import {Link, useLocation} from 'react-router-dom';

const BlogPage: FC = () => {
  const {pathname} = useLocation();

  useEffect(() => {
    document?.querySelector('body')?.scrollTo(0, 0);
  }, [pathname]);
  return (
    <div className='blog-page'>
      <div className='blog-page__wrap'>
        <div className='blog-page__header bg-dark blackout'>
          <Header />
          <div className='wrap'>
            <div className='blog-page__preview'>
              <h1>About WeSmart</h1>
              <p className='blog-page__desc'>Some words aboy the company</p>
              <Link to={'/products'} className='button-orange'>
                Explore our product
              </Link>
            </div>
          </div>
        </div>
        <div className='wrap '>
          <div className='padding-space-top padding-space-bottom'>
            <div className='about-page about-page__row'>
              <div className='about-page__box'>
                <h2 className='about-page__text'>
                  Award-winning video technology
                </h2>
                <p className='about-page__text-info'>
                  <span>Some word about your work as a description.</span>
                  <span>
                    Lorem ipsum dolor sit amet consectetur. Purus tristique odio
                    posuere et cursus. In scelerisque eu sit pulvinar et duis
                    elit. Lorem ipsum dolor sit amet consectetur. Purus
                    tristique odio posuere et cursus. In scelerisque eu sit
                    pulvinar et duis elit. Lorem ipsum dolor sit amet
                    consectetur. Purus tristique odio posuere et cursus. In
                    scelerisque eu sit pulvinar et duis elit.
                  </span>
                </p>
                <Link
                  to={'/products'}
                  className='about-page__button button-orange'
                >
                  Explore our product
                </Link>
              </div>
              <div className='about-page__image'></div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default BlogPage;
