'use client';
import React, {FC, ReactNode, useEffect} from 'react';
import ContactCard from '../../components/ContactCard/ContactCard';
import Header from '../../components/Header/Header';
import './ContactsPage.scss';
import MobileHeader from '../../components/MobileHeader/MobileHeader';
import useResponsiveHeader from '../../components/useResponsiveHeader/useResponsiveHeader';
import {CardContactType} from '../../types/types';
import phone from '../../asserts/phone-icon.svg';
import box from '../../asserts/box-icon.svg';
import chat from '../../asserts/chat-icon.svg';
import {useLocation} from 'react-router-dom';
import {useSelector} from 'react-redux';
import {RootState} from '../../store/store';
import ParamParser from '../../helper/ParamParser';

const Contacts: FC = () => {
  const parserParam = ParamParser();
  const {isMobileHeader, isSmallScreen, showHeader, handleClick} =
    useResponsiveHeader();
  const {pathname} = useLocation();

  const contact = useSelector(
    (state: RootState) => state.language.currentLanguage.contactPage,
  );

  useEffect(() => {
    document?.querySelector('body')?.scrollTo(0, 0);
  }, [pathname]);
  return (
    <div className={'contact-page'}>
      {isSmallScreen && (
        <MobileHeader isActive={isMobileHeader} handelClick={handleClick} />
      )}
      <div className='bg-dark'>{showHeader && <Header />}</div>
      <div className={'contact-page__wrap'}>
        <div className='wrap'>
          <h2 className={`h2 ${'contact-page__title'}`}> {contact.title}</h2>
          <p className={'contact-page__desc'}>{contact.desc}</p>
          <div className={'contact-page__row'}>
            {contact.CONTACT_CARDS.map((card: any, i: any) => {
              return <ContactCard key={i} card={card} />;
            })}
          </div>
        </div>
      </div>
    </div>
  );
};

export default Contacts;
