'use client';
import React, {FC, useEffect, useState} from 'react';
import './MainPage.scss';
import Header from '../../components/Header/Header';
import Preview from '../../components/Preview/Preview';
import AboutUs from '../../components/AboutUs/AboutUs';
import Suggestions from '../../components/Suggestion/Suggestion';
import Benefits from '../../components/Benefits/Benefits';
import Contacts from '../../components/Contacts/Contacts';
import MobileHeader from '../../components/MobileHeader/MobileHeader';
import useResponsiveHeader from '../../components/useResponsiveHeader/useResponsiveHeader';
import {useLocation, useParams} from 'react-router-dom';
import {useDispatch} from 'react-redux';
import {AppDispatch, RootState} from '../../store/store';
import {setLanguages} from '../../store/languages/actions';
import {useSelector} from 'react-redux';
import ParamParser from '../../helper/ParamParser';

const Home: FC = () => {
  const {isMobileHeader, isSmallScreen, showHeader, handleClick} =
    useResponsiveHeader();
  const parserParam = ParamParser();

  const {pathname} = useLocation();
  useEffect(() => {
    document?.querySelector('body')?.scrollTo(0, 0);
  }, [pathname]);

  return (
    <div className={'home'}>
      <div className={'home__wrap'}>
        {isSmallScreen && (
          <MobileHeader isActive={isMobileHeader} handelClick={handleClick} />
        )}
        <div className={'home__header'}>
          {showHeader && <Header />}
          <Preview />
        </div>
        <div className='padding-space bg-dark '>
          <AboutUs />
        </div>
        <div className='padding-space bg-light'>
          <Suggestions />
        </div>
        <div className='padding-space bg-dark'>
          <Benefits />
        </div>
        <div className='padding-space bg-light'>
          <Contacts />
        </div>
      </div>
    </div>
  );
};
export default Home;
