import CardAbout from '../../components/CardAbout/CardAbout';
import Header from '../../components/Header/Header';
import ProductCard from '../../components/ProductCard/ProductCard';
import './ProductDescriptionPage.scss';
import ProductCategory from '../../components/ProductCategory/ProductCategory';
import MobileHeader from '../../components/MobileHeader/MobileHeader';
import useResponsiveHeader from '../../components/useResponsiveHeader/useResponsiveHeader';
import {Link, useLocation} from 'react-router-dom';
import demo from '../../asserts/product-demo.png';
import {useEffect} from 'react';
import {useSelector} from 'react-redux';
import {RootState} from '../../store/store';
import ParamParser from '../../helper/ParamParser';

type Props = {
  params: {
    slug: string;
  };
};

const ProductDescriptionPage = () => {
  const parserParam = ParamParser();
  const {pathname} = useLocation();
  const product = useSelector(
    (state: RootState) => state.language.currentLanguage.description,
  );
  const state = useSelector((state: RootState) => state.language);
  useEffect(() => {
    document?.querySelector('body')?.scrollTo(0, 0);
  }, [pathname]);
  const {isMobileHeader, isSmallScreen, showHeader, handleClick} =
    useResponsiveHeader();
  return (
    <div className={'product_desc_page'}>
      <div className={'product_desc_page__wrap'}>
        {isSmallScreen && (
          <MobileHeader isActive={isMobileHeader} handelClick={handleClick} />
        )}
        <div className='bg-light-blue '>
          {showHeader && <Header />}
          <div className={'product_desc_page__preview'}>
            <ProductCard odd={true} card={product.DEFAULT_CARD} />
          </div>
        </div>
        <div>
          <div className={`${'product_desc_page__card'} padding-space-top `}>
            <CardAbout
              odd={false}
              src={demo}
              title={product.cardAboutA.title}
              desc={product.cardAboutA.desc}
            />
          </div>
          <div className={` ${'product_desc_page__card'}  padding-space-top `}>
            <CardAbout
              odd={true}
              src={demo}
              title={product.cardAboutB.title}
              desc={product.cardAboutA.desc}
            />
          </div>
          <div className={`${'product_desc_page__card'} padding-space `}>
            <CardAbout
              src={demo}
              title={product.cardAboutC.title}
              desc={product.cardAboutA.desc}
            />
          </div>
        </div>
        <div className='bg-light-blue padding-space'>
          <div className='wrap'>
            <div className={'product_desc_page__row'}>
              <div className={'product_desc_page__info'}>
                <h2 className={'product_desc_page__title'}>{product.title}</h2>
                <p className={'product_desc_page__desc'}>
                  {product.desc.map((item: any, i: any) => (
                    <span key={i}>{item}</span>
                  ))}
                </p>
                <Link
                  to={`/${state.selectedLanguage}/contacts`}
                  className={`${'product_desc_page__link'} button-orange`}
                >
                  {state.currentLanguage.contacts.title}
                </Link>
              </div>
              <div className={'product_desc_page__categories'}>
                {product.DEFAULT_PRODUCT_LINK.map((category: any, i: any) => {
                  return <ProductCategory category={category} key={i} />;
                })}
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default ProductDescriptionPage;
