'use client';
import React, {useEffect} from 'react';

import Header from '../../components/Header/Header';
import ProductCard from '../../components/ProductCard/ProductCard';
import './ProductsPage.scss';
import MobileHeader from '../../components/MobileHeader/MobileHeader';
import useResponsiveHeader from '../..//components/useResponsiveHeader/useResponsiveHeader';
import {useLocation, useParams} from 'react-router-dom';
import {useSelector} from 'react-redux';
import {RootState} from '../../store/store';
import ContactInfo from '../../components/ContactInfo/ContactInfo';
import Contacts from '../../components/Contacts/Contacts';
import ParamParser from '../../helper/ParamParser';

export default function ProductsPage() {
  const parserParam = ParamParser();
  const productPage = useSelector(
    (state: RootState) => state.language.currentLanguage.product,
  );

  const {isMobileHeader, isSmallScreen, showHeader, handleClick} =
    useResponsiveHeader();
  const {pathname} = useLocation();

  useEffect(() => {
    document?.querySelector('body')?.scrollTo(0, 0);
  }, [pathname]);
  return (
    <div className={'product_page'}>
      <div className={'product_page__wrap'}>
        {isSmallScreen && (
          <MobileHeader isActive={isMobileHeader} handelClick={handleClick} />
        )}
        <div className={`bg-dark`}>
          <div className={'product_page__bg'}>
            <div className='wrap '>
              {showHeader && <Header />}
              <div className={'product_page__box'}>
                <h1 className={` ${'product_page__title'} h1`}>
                  {productPage.title}
                </h1>
                <p className={'product_page__desc'}>
                  {productPage.desc.map((item: any, i: any) => {
                    return <span key={i}>{item}</span>;
                  })}
                </p>
              </div>
            </div>
          </div>
        </div>
        <div
          className={`${'product_page__section'} bg-light-blue padding-space-top padding-space-bottom`}
        >
          <div className='wrap'>
            <h2 className={'product_page__text'}>{productPage.text}</h2>
          </div>
        </div>
        <div>
          {productPage.PRODUCT_CARD.map((card: any, index: any) => {
            return (
              <div className={'product_page__inner'} key={index}>
                <ProductCard odd={card.odd} card={card} />
              </div>
            );
          })}
        </div>
        <div className='padding-space'>
          <Contacts />
        </div>
      </div>
    </div>
  );
}
