'use client';
import Header from '../../components/Header/Header';
import './Solutions.scss';
import Card from '../../components/Benefits/Card/Card';
import CardAbout from '../../components/CardAbout/CardAbout';
import ContactInfo from '../../components/ContactInfo/ContactInfo';
import MobileHeader from '../../components/MobileHeader/MobileHeader';
import useResponsiveHeader from '../../components/useResponsiveHeader/useResponsiveHeader';
import bg from '../../asserts/unsplash__QoAuZGAoPY.png';
import img from '../../asserts/unsplash_eT8YmUWJjQ0.png';
import {useEffect} from 'react';
import {useLocation} from 'react-router-dom';
import {useSelector} from 'react-redux';
import {RootState} from '../../store/store';
import ParamParser from '../../helper/ParamParser';

const Cities = () => {
  const parserParam = ParamParser();
  let state = useSelector(
    (state: RootState) => state.language.currentLanguage.citiesPage,
  );

  const {pathname} = useLocation();

  useEffect(() => {
    document?.querySelector('body')?.scrollTo(0, 0);
  }, [pathname]);
  const {isMobileHeader, isSmallScreen, showHeader, handleClick} =
    useResponsiveHeader();
  return (
    <div className='sol_page'>
      <div className='sol_page__wrap '>
        {isSmallScreen && (
          <MobileHeader isActive={isMobileHeader} handelClick={handleClick} />
        )}
        <div
          className={`${'sol_page__header'} sol_page__header blackout`}
          style={{background: `center/cover no-repeat url(${state.bg})`}}
        >
          <div className='wrap  '>
            {showHeader && <Header />}
            <div className={'sol_page__box'}>
              <h1 className={` ${'sol_page__title'} h1`}>{state.title}</h1>
              <p className={'sol_page__desc'}>
                {state.desc.map((item: any, i: any) => (
                  <span key={i}>{item}</span>
                ))}
              </p>
            </div>
          </div>
        </div>
        <div className='bg-dark padding-space'>
          <div className={`${'sol_page__row'} wrap`}>
            {state.BENEFITS_CARDS_LOGISTICS.map((item: any, index: any) => {
              return (
                <div key={index} className={'sol_page__card'}>
                  <Card item={item} />
                </div>
              );
            })}
          </div>
        </div>

        <div className='padding-space'>
          <CardAbout
            src={bg}
            odd={false}
            withButton={false}
            title={state.CardAboutA.title}
            desc={state.CardAboutA.desc}
          />
        </div>
        <div className={'sol_page__padding_bottom'}>
          <CardAbout
            src={img}
            odd={true}
            withButton={true}
            title={state.CardAboutB.title}
            desc={[
              `Lorem ipsum dolor sit amet consectetur. Purus
         tristique odio posuere et cursus. In scelerisque eu sit pulvinar et duis elit. `,
              `Lorem ipsum dolor
          sit amet consectetur. Purus tristique odio posuere et cursus. In scelerisque eu sit pulvinar et duis 
          elit. Lorem ipsum dolor sit amet consectetur. Purus tristique odio posuere et cursus. In scelerisque e
          u sit pulvinar et duis elit. Lorem ipsum dolor sit amet consectetur. Purus tristique odio posuere et cursus. 
          In scelerisque eu sit pulvinar et duis elit.`,
            ]}
          />
        </div>
        <div className='bg-dark '>
          <div className='wrap'>
            <div className={'sol_page__banner'}>
              <div className={'sol_page__img'}></div>
              <div className={'sol_page__info'}>
                <h2 className='h2 '>{state.appTitle}</h2>
                <p className={'sol_page__text'}>
                  {state.appDesc.map((text: any, i: any) => (
                    <span key={i}>{text}</span>
                  ))}
                </p>
              </div>
            </div>
          </div>
        </div>
        <div className='wrap'>
          <div className={`${'sol_page__contact'} padding-space`}>
            <ContactInfo card={state.card} />
          </div>
        </div>
      </div>
    </div>
  );
};

export default Cities;
