export type CardAboutT = {
  src: string;
  odd?: boolean;
  title: string;
  desc: Array<string>;
  withButton?: boolean;
};

// Product Card
export type CardT = {
  img: string;
  odd: boolean;
  date: string;
  name: string;
  url?: string;
  title: string;
  desc: string;
  isGeneralPage: boolean;
};
export type ProductCardT = {
  card: CardT;
  odd?: boolean;
};

export type CategoryT = {
  label: string;
  url?: string;
  title: string;
};
export type ProductCategoryT = {
  category: CategoryT;
};

// contact cards
export type CardContactType = {
  url?: string;
  src?: string;
  labelUrl?: string;
  title: string;
  desc: string;
  phone?: boolean;
};

// chat bot card
export type ChatBotCardT = {
  info: {title: string; desc: string};
};
